// src/components/users/CreateUser.js
import React from 'react';
import { Create, SimpleForm, TextInput, required, email } from 'react-admin';

const CreateUser = (props) => {
  return (
    <Create title="Crear Usuario" {...props}>
      <SimpleForm>
        <TextInput
          source="firstName"
          label="Nombre"
          validate={required()}
        />
        <TextInput
          source="lastName"
          label="Nombre"
          validate={required()}
        />
        <TextInput
          source="email"
          label="Correo Electrónico"
          validate={[required(), email()]}
        />
        <TextInput
          source="username"
          label="Nombre de Usuario"
          validate={required()}
        />
        <TextInput
          source="password"
          label="Contraseña"
          type="password"
          validate={required()}
        />
        <TextInput
          source="role"
          label="Rol"
          validate={required()}
        />
      </SimpleForm>
    </Create>
  );
};

export default CreateUser;
