import React from 'react';
import {
  List,
  Datagrid,
  TextField,
  DateField,
  NumberField,
  FunctionField,
  Filter,
  TextInput,
  DateInput,
} from "react-admin";
import { CapturasExpand } from './CapturasExpand';

const SalidaPescaFilter = (props) => (
  <Filter {...props}>
    <TextInput source="id" label="ID" alwaysOn />
    <DateInput source="fecha_partida_gte" label="Fecha de Partida Desde" />
    <DateInput source="fecha_partida_lte" label="Fecha de Partida Hasta" />
    <DateInput source="fecha_arribo_gte" label="Fecha de Arribo Desde" />
    <DateInput source="fecha_arribo_lte" label="Fecha de Arribo Hasta" />
    <TextInput source="tipo_flota" label="Tipo de Flota" />
    <TextInput source="zonas_literal" label="Zonas Literal" />
    <NumberField source="tripulantes" label="Número de Tripulantes" />
    <NumberField source="profundidad_min" label="Profundidad Mínima" />
    <NumberField source="profundidad_max" label="Profundidad Máxima" />
    <NumberField source="horas_buceo" label="Horas de Buceo" />
    <NumberField source="horas_pesca" label="Horas de Pesca" />
    <NumberField source="cant_buzos" label="Cantidad de Buzos" />
    <NumberField source="cant_anzuelos" label="Cantidad de Anzuelos" />
    <NumberField source="cant_lances" label="Cantidad de Lances" />
    <NumberField source="cant_cajones" label="Cantidad de Cajones" />
    <NumberField source="cant_bolsas" label="Cantidad de Bolsas" />
  </Filter>
);

export const SalidaPescaList = () => (
  <List filters={<SalidaPescaFilter />}>
    <Datagrid  expand={<CapturasExpand />}>
      <TextField source="id" label="ID" />
      <DateField source="fecha_partida" label="Fecha de Partida" />
      <DateField source="fecha_arribo" label="Fecha de Arribo" />
      <TextField source="tipo_flota" label="Tipo de Flota" />
      <NumberField source="tripulantes" label="Número de Tripulantes" />
      <NumberField source="profundidad_min" label="Profundidad Mínima" />
      <NumberField source="profundidad_max" label="Profundidad Máxima" />
      <NumberField source="horas_buceo" label="Horas de Buceo" />
      <NumberField source="horas_pesca" label="Horas de Pesca" />
      <NumberField source="cant_buzos" label="Cantidad de Buzos" />
      <NumberField source="cant_anzuelos" label="Cantidad de Anzuelos" />
      <NumberField source="cant_lances" label="Cantidad de Lances" />
      <NumberField source="cant_cajones" label="Cantidad de Cajones" />
      <NumberField source="cant_bolsas" label="Cantidad de Bolsas" />
      <TextField source="zonas_literal" label="Zonas Literal" />
      <FunctionField
        label="Total Capturas"
        render={(record) => (record?.capturas?.length || 0)}
      />
    </Datagrid>
  </List>
);
