import React from 'react';
import { Datagrid, TextField, NumberField, useRecordContext } from "react-admin";

export const CapturasExpand = () => {


  const record = useRecordContext();


  if (!record || !record.capturas) {
    return <div>No hay capturas disponibles para esta salida.</div>;
  }

  return (
    <Datagrid data={record.capturas} isExpandable={false}>
      {/*<TextField source="id" label="ID" />*/}
      <TextField source="especie.nombre_vulgar" label="Especie"/>
      <NumberField source="cantidad" label="Cantidad" />
      <TextField source="unidad" label="Unidad" />
      {/*<NumberField source="profundidad" label="Profundidad" />*/}
    </Datagrid>
  );
};
