import { AuthProvider, fetchUtils, HttpError } from "react-admin";

import { jwtDecode } from "jwt-decode";
import { useAuth } from "./AuthContext.tsx";


let triggerAuthChange: (() => void) | null = null;

export const setAuthChangeCallback = (callback: () => void) => {
  triggerAuthChange = callback;
};
/**
 * This authProvider is only for test purposes. Don't use it in production.
 */
export const authProvider: AuthProvider = {




  login: async ({ username, password }) => {
    const apiUrl = import.meta.env.VITE_API_URL;

    const body = {username:username, password:password};
      // console.log(body);
    //   const request = new Request('http://localhost:3355/api/auth/login', {
    //   method: 'POST',
    //   body: JSON.stringify(body),
    //   headers: new Headers({ 'Content-Type': 'application/json' }),
    // });

    const response = await fetchUtils.fetchJson(`${apiUrl}/auth/login`,{
      method: 'POST',
      body: JSON.stringify(body),
      headers: new Headers({ 'Content-Type': 'application/json' }),
    });
    const { access_token, user } = response.json;

    if (!access_token) {
      throw new Error('Invalid login');
    }

    if (triggerAuthChange) triggerAuthChange(); // Notifica el cambio


    // Guarda el token en localStorage
    localStorage.setItem('authToken', access_token);
    localStorage.setItem('user', JSON.stringify(user));

  },
  logout: () => {
    // Elimina el token al cerrar sesión
    localStorage.removeItem('authToken');
    localStorage.removeItem('user');

    if (triggerAuthChange) triggerAuthChange(); // Notifica el cambio


    return Promise.resolve();
  },
  checkError: () => Promise.resolve(),
  checkAuth: () => {
    const token = localStorage.getItem('authToken');
    if (!token) {
      return Promise.reject({ redirectTo: '/login' });
    }

    try {
      const decodedToken = jwtDecode(token);
      // console.log(decodedToken);
      const currentTime = Date.now() / 1000;
      if (decodedToken.exp < currentTime) {
        localStorage.removeItem('authToken');
        localStorage.removeItem('user');
        return Promise.reject({ redirectTo: '/login' }); // Token expirado
      }
      return Promise.resolve();
    } catch (e) {
      localStorage.removeItem('authToken');
      localStorage.removeItem('user');
      return Promise.reject({ redirectTo: '/login' });
    }
  },
  getPermissions: () => {
    const user = localStorage.getItem("user");
    const role = user ? JSON.parse(user).role : null;

    return Promise.resolve(role);
  },
  getIdentity: () => {
    const persistedUser = localStorage.getItem("user");
    const user = persistedUser ? JSON.parse(persistedUser) : null;

    return Promise.resolve(user);
  },
};

export default authProvider;
