import React, { createContext, useContext, useState, ReactNode } from "react";

interface AuthContextType {
  authKey: number;
  triggerAuthChange: () => void; // Callback para notificar cambios
}

const AuthContext = createContext<AuthContextType | undefined>(undefined);

export const AuthProvider = ({ children }: { children: ReactNode }) => {
  const [authKey, setAuthKey] = useState(0);

  const triggerAuthChange = () => {
    setAuthKey((prevKey) => prevKey + 1);
  };

  return (
    <AuthContext.Provider value={{ authKey, triggerAuthChange }}>
      {children}
    </AuthContext.Provider>
  );
};

export const useAuth = () => {
  const context = useContext(AuthContext);
  if (!context) throw new Error("useAuth must be used within AuthProvider");
  return context;
};
