import React, { useEffect, useState } from "react";
import { Admin, Resource, ListGuesser, EditGuesser, ShowGuesser } from "react-admin";
import { authProvider, setAuthChangeCallback } from "./authProvider";
import crudProvider from "../helpers/ra-data-nest-crud";
import CreateUser from "./resources/User/CreateUser.tsx";
import { Layout } from "./Layout";
import { AuthProvider, useAuth } from "./AuthContext";
import { SalidaPescaList } from "./resources/SalidaPesca/SalidaPescaList.tsx";

const apiUrl = import.meta.env.VITE_API_URL;
const dataProvider = crudProvider(apiUrl);

const AdminApp = () => {
  const [permissions, setPermissions] = useState<string | null>(null);
  const [loading, setLoading] = useState(true);
  const { authKey, triggerAuthChange } = useAuth(); // Usamos la key y la función del contexto

  useEffect(() => {
    // Registramos el callback
    setAuthChangeCallback(triggerAuthChange);

    authProvider
      .getPermissions()
      .then((role) => {
        setPermissions(role);
        setLoading(false);
      })
      .catch(() => {
        setPermissions(null);
        setLoading(false);
      });
  }, [authKey]); // Se actualiza cuando triggerAuthChange se ejecuta

  if (loading) {
    return <div>Loading...</div>;
  }

  return (
    <Admin layout={Layout} authProvider={authProvider} dataProvider={dataProvider}>
      <Resource name="salida-pesca" list={SalidaPescaList}  />
      <Resource
        name="embarcacion"
        list={ListGuesser}
        edit={permissions === "ADMIN" ? EditGuesser : undefined} // Condición para EditGuesser
        show={ShowGuesser}
      />
      <Resource name="puerto" list={ListGuesser}
                edit={permissions === "ADMIN" ? EditGuesser : undefined} // Condición para EditGuesser
                show={ShowGuesser} />
      <Resource name="especie" list={ListGuesser}
                edit={permissions === "ADMIN" ? EditGuesser : undefined} // Condición para EditGuesser
                show={ShowGuesser} />

      {permissions === "ADMIN" && (
        <Resource
          name="users"
          list={ListGuesser}
          edit={EditGuesser}
          show={ShowGuesser}
          create={CreateUser}
        />
      )}
    </Admin>
  );
};

export const App = () => (
  <AuthProvider>
    <AdminApp />
  </AuthProvider>
);
