import { RequestQueryBuilder, CondOperator,  } from '@nestjsx/crud-request';
import {fetchUtils, GET_LIST, GET_ONE, GET_MANY, GET_MANY_REFERENCE, UPDATE, DELETE, CREATE} from 'react-admin';

const crudProvider = (apiUrl, authType = null, authCredentials = null, httpClient = fetchUtils.fetchJson) => {
    // Función modificada para incluir el encabezado de Autorización si es necesario
    const httpClientWithAuth = async (url, options ) => {
        // if (!options.headers) {
        //     options.headers = new Headers({ Accept: 'application/json' });
        // }
        //
        // // Configurar el encabezado de Authorization basado en el tipo y credenciales proporcionadas
        // if (authType && authCredentials) {
        //     if (authType === 'bearer') {
        //         options.headers.set('Authorization', `Bearer ${authCredentials}`);
        //     } else if (authType === 'basic') {
        //         const encodedCredentials = btoa(authCredentials); // authCredentials debe ser 'username:password'
        //         options.headers.set('Authorization', `Basic ${encodedCredentials}`);
        //     }
        // }
        const token = localStorage.getItem('authToken');
        // console.log('options: ', options.headers);
        const headers = new Headers();
        headers.set('Authorization', `Bearer ${token}`);
        options.headers = headers;


        return httpClient(url, options);
    };
    const composeFilter = (paramsFilter) => {
        if (paramsFilter === '' || (typeof paramsFilter.q !== 'undefined' && paramsFilter.q === '')) {
            paramsFilter = {};
        }

        const flatFilter = fetchUtils.flattenObject(paramsFilter);
        const filter = Object.keys(flatFilter).map((key) => {
            const splitKey = key.split('||');
            // console.log("key:",flatFilter[key]);
            // console.log("paramsFilter:",paramsFilter);
            let comparation = 'cont';
            let field = splitKey[0];

            if(key.startsWith("_")){
                comparation='eq';
                // key=splitKey[2].substring(1);
                field = field.substring(1);
            }
            const ops = splitKey[1] ? splitKey[1] : comparation;



            if (field.indexOf('_') === 0 && field.indexOf('.') > -1) {
                field = field.split(/\.(.+)/)[1];
            }
            return { field, operator: ops, value: flatFilter[key] };
        });
        return filter;
    };

    const convertDataRequestToHTTP = (type, resource, params) => {

        let url = '';
        const options = {};
        switch (type) {
            case GET_LIST: {
                const { page, perPage } = params.pagination;
                const query = RequestQueryBuilder
                    .create({
                        filter: composeFilter(params.filter),
                    })
                    .setLimit(perPage)
                    .setPage(page)
                    .sortBy(params.sort)
                    .setOffset((page - 1) * perPage)
                    .query();

                url = `${apiUrl}/${resource}?${query}`;
                break;
            }
            case GET_ONE: {
                url = `${apiUrl}/${resource}/${params.id}`;
                break;
            }
            case GET_MANY: {
                const query = RequestQueryBuilder
                    .create()
                    .setFilter({
                        field: 'id',
                        operator: CondOperator.IN,
                        value: `${params.ids}`,
                    })
                    .query();

                url = `${apiUrl}/${resource}?${query}`;
                break;
            }
            case GET_MANY_REFERENCE: {
                const { page, perPage } = params.pagination;
                const filter = composeFilter(params.filter);

                filter.push({
                    field: params.target,
                    operator: CondOperator.EQUALS,
                    value: params.id,
                });

                const query = RequestQueryBuilder
                    .create({
                        filter,
                    })
                    .sortBy(params.sort)
                    .setLimit(perPage)
                    .setOffset((page - 1) * perPage)
                    .query();

                url = `${apiUrl}/${resource}?${query}`;
                break;
            }
            case UPDATE: {
                url = `${apiUrl}/${resource}/${params.id}`;
                options.method = 'PUT';
                options.body = JSON.stringify(params.data);
                break;
            }
            case CREATE: {
                url = `${apiUrl}/${resource}`;
                options.method = 'POST';
                options.body = JSON.stringify(params.data);
                break;
            }
            case DELETE: {
                url = `${apiUrl}/${resource}/${params.id}`;
                options.method = 'DELETE';
                break;
            }
            default:
                throw new Error(`Unsupported fetch action type ${type}`);
        }
        return { url, options };
    };

    const convertHTTPResponse = (response, type, resource, params) => {
        // console.log('params: ', params)
        // console.log('type: ', type)
        const { headers, json } = response;
        switch (type) {
            case GET_LIST:
            case GET_MANY_REFERENCE:
                return {
                    data: json.data,
                    total: json.total,
                };
            case CREATE:
                return { data: { ...params.data, id: json.id } };
            default:
                return { data: json };
        }
    };

    return (type, resource, params) => {
        // La lógica para manejar UPDATE_MANY y DELETE_MANY permanece igual aquí
        // ...

        const { url, options } = convertDataRequestToHTTP(type, resource, params);
        return httpClientWithAuth(url, options).then(response => convertHTTPResponse(response, type, resource, params));
    };
};

export default crudProvider;
