import { Module } from '@nestjs/common';
import { ZonaPescaService } from './zona_pesca.service';
import { ZonaPescaController } from './zona_pesca.controller';
import { TypeOrmModule } from "@nestjs/typeorm";
import { Embarcacion } from "../entities/embarcacion.entity";
import { SalidaPesca } from "../entities/salida.pesca.entity";
import { Captura } from "../entities/captura.entity";
import { ArtePesca } from "../entities/arte.pesca.entity";
import { ZonaPesca } from "../entities/zona.pesca.entity";
import { UsersModule } from "../users/users.module";

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Embarcacion,
      SalidaPesca,
      Captura,
      ArtePesca,
      ZonaPesca,
    ]),
    UsersModule,
  ],
  controllers: [ZonaPescaController],
  providers: [ZonaPescaService],
})
export class ZonaPescaModule {}
