import { IsEnum, 
    IsNotEmpty, 
    IsNumber, 
    IsOptional, 
    IsString } from "class-validator";
import { ApiProperty } from "@nestjs/swagger";


export class ZonaPescaDTO {
    @ApiProperty()
    @IsOptional()
    @IsString()
    descripcion: string;

    @ApiProperty()
    @IsOptional()
    @IsString()
    coordenadas: string;
    
}


export class ZonaPescaUpdateDTO {
    @ApiProperty()
    @IsOptional()
    @IsString()
    descripcion: string;

    @ApiProperty()
    @IsOptional()
    @IsString()
    coordenadas: string;
}