import { IsEnum, 
    IsNotEmpty, 
    IsOptional, 
    IsString } from "class-validator";
import { ROLES } from '../constants/roles';
import { ApiProperty } from "@nestjs/swagger";


export class UsersDTO {
    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    firstName: string;

    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    lastName: string;

    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    email: string;

    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    username: string;

    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    password: string;

    @ApiProperty()
    @IsNotEmpty()
    @IsEnum(ROLES)
    role: ROLES;
}

export class UsersUpdateDTO {
    @ApiProperty()
    @IsOptional()
    @IsString()
    firsName: string;

    @ApiProperty()
    @IsOptional()
    @IsString()
    lastName: string;

    @ApiProperty()
    @IsOptional()
    @IsString()
    email: string;

    @ApiProperty()
    @IsOptional()
    @IsString()
    userName: string;

    @ApiProperty()
    @IsOptional()
    @IsString()
    password: string;

    @ApiProperty()
    @IsOptional()
    @IsEnum(ROLES)
    role: ROLES;
}