import { Body, Controller, Delete, Get, Param, Post, Put, UseGuards } from '@nestjs/common';
import { UsersEntity } from '../entities/users.entity';
import { UsersDTO, UsersUpdateDTO } from './users.dto';
import { UsersService } from './users.service';
import { AuthGuard } from '../auth/auth.guard';
import { RolesGuard } from '../auth/roles.guard';
import { AdminAccess } from '../auth/decorators/admin.detorator';
import { PublicAccess } from 'src/auth/decorators/public.decorator';
import { Roles } from '../auth/decorators/roles.decorator';
import { ApiOperation, ApiParam, ApiResponse, ApiTags, getSchemaPath } from '@nestjs/swagger';

@ApiTags('Users')
@Controller('users')
@UseGuards(AuthGuard, RolesGuard)
export class UsersController {
    constructor(private readonly userService: UsersService){}

    @ApiOperation({
        summary: 'Crear un nuevo usuario',
        description: 'Crea un nuevo usuario.',
      })
    @ApiResponse({
        status: 200,
        description: 'Entidad creada correctamente',
        schema: { $ref: getSchemaPath(UsersDTO) },
      })
    @Post('')
    public async registerUser(@Body() body: UsersDTO){
        return await this.userService.createUser(body);
    }

    @AdminAccess()
    @Get('')
    // @AdminAccess()
    @ApiOperation({
        summary: 'Obtener una lista de usuarios',
        description: 'Retorna una lista de usuarios.',
      })
    @ApiResponse({
        status: 200,
        description: 'Entidad encontrada correctamente',
        schema: { $ref: getSchemaPath(UsersDTO) },
      })
    @Get('')
    public async findAllUsers(){
        const users =  await this.userService.findUsers();
        return {data: users};
    }

    @ApiParam( {name: 'id'})
    @ApiOperation({
        summary: 'Busca el registro del usuario seleccionado',
        description: 'Busca el registro usuario seleccionado.',
      })
@ApiResponse({
        status: 200,
        description: 'Entidad encontrada correctamente',
        schema: { $ref: getSchemaPath(UsersDTO) },
      })
    @Get(':id')
    public async findUserById(@Param('id') id: string){
        return await this.userService.findUserById(id);
    }

    @ApiParam( {name: 'id'})
    @AdminAccess()
    @Put(':id')
    public async updateUser(@Param('id') id: string, @Body() body: UsersUpdateDTO){
        return await this.userService.updateUser(body, id);
    }

    @ApiParam( {name: 'id'})
    @ApiOperation({
              summary: 'Borra el registro del usuario seleccionado',
              description: 'Elimina el registro usuario seleccionado.',
            })
    @ApiResponse({
              status: 200,
              description: 'Entidad eliminada correctamente',
              schema: { $ref: getSchemaPath(UsersDTO) },
            })
    @AdminAccess()
    @Delete(':id')
    public async deleteUser(@Param('id') id: string){
        return await this.userService.deleteUser(id);
    }
}
