import { Injectable } from '@nestjs/common';
import { TypeOrmCrudService } from '@dataui/crud-typeorm';
import { InjectRepository } from '@nestjs/typeorm';
import { SalidaPesca } from '../entities/salida.pesca.entity';
import { Embarcacion } from '../entities/embarcacion.entity';
import { Repository } from 'typeorm';
import { Puerto } from '../entities/puerto.entity';
import { ArtePesca } from '../entities/arte.pesca.entity';
import { Captura } from '../entities/captura.entity';
import { Especie } from '../entities/especie.entity';
import { CrudRequest, GetManyDefaultResponse } from "@dataui/crud";

@Injectable()
export class SalidaPescaService extends TypeOrmCrudService<SalidaPesca> {
  constructor(
    @InjectRepository(Embarcacion)
    private embarcacionRepository: Repository<Embarcacion>,
    @InjectRepository(Puerto)
    private puertoRepository: Repository<Puerto>,
    @InjectRepository(ArtePesca)
    private artePescaRepository: Repository<ArtePesca>,
    @InjectRepository(Captura)
    private capturaRepository: Repository<Captura>,
    @InjectRepository(Especie)
    private especieRepository: Repository<Especie>,
    @InjectRepository(SalidaPesca) repo,
  ) {
    super(repo);
  }

  // public async getMany(req: CrudRequest) {
  //   const { parsed, options } = req;
  //
  //   const builder = await this.createBuilder(parsed, options);
  //   // builder.addFrom(()=>codeBuilder,alias);
  //   const relation = 'capturas';
  //   // const relation2 = 'plan';
  //   builder.leftJoinAndSelect(`${this.alias}.${relation}`, relation); // Incluye la relación que necesitas
  //   // builder.leftJoinAndSelect(`${this.alias}.${relation2}`, relation2); // Incluye la relación que necesitas
  //
  //   return this.doGetMany(builder, parsed, options);
  // }

  async createOne(req: any, dto: Partial<any>): Promise<SalidaPesca> {
    // Tu lógica personalizada para crear una entidad
    const nuevaSalida: SalidaPesca = this.repo.create({
      ...dto,
      // Puedes agregar valores personalizados o lógicos aquí
      // fecha_partida: dto.fecha_partida || new Date(), // Si no se proporciona, usa la fecha actual
      // tipo_flota: dto.tipo_flota || 'Desconocida', // Valor por defecto
    });

    const embarcacion = await this.embarcacionRepository.findOne({
      where: { nombre: dto.embarcacion },
    });
    const puertoPartida = await this.puertoRepository.findOne({
      where: { nombre: dto.puerto_partida },
    });
    const puertoArribo = await this.puertoRepository.findOne({
      where: { nombre: dto.puerto_arribo },
    });
    const artePesca = await this.artePescaRepository.findOne({
      where: { tipo: dto.ARTE_DE_PESCA },
    });

    // Obtener los campos que vienen después de "especies"
    const especiesIndex = Object.keys(dto).indexOf('especies');

    const capturas = [];
    //
    if (especiesIndex !== -1) {
      const camposPosteriores = Object.entries(dto).slice(especiesIndex + 1);
      //
      for (let i = 0; i < camposPosteriores.length; i++) {
        const [campo, valor] = camposPosteriores[i];
        i++;
        const [campoUnidad, unidad] = camposPosteriores[i];
        if (valor > 0) {
          try {
            const especie = await this.especieRepository.findOne({
              where: { nombre_vulgar: campo },
            });
            const captura = new Captura();
            captura.especie = especie;
            captura.cantidad = valor;
            captura.unidad = unidad;
            capturas.push(captura);
          } catch (e) {
            console.log(e);
          }
        }
      };
      nuevaSalida.capturas = capturas;
    }

    nuevaSalida.puerto_partida = puertoPartida;
    nuevaSalida.puerto_arribo = puertoArribo;
    nuevaSalida.arte = artePesca;
    nuevaSalida.embarcacion = embarcacion;
    nuevaSalida.profundidad_min = dto.profundidad_min || 0;
    nuevaSalida.profundidad_max = dto.profundidad_max || 0;
    nuevaSalida.cant_anzuelos = dto.cant_anzuelos || 0;
    nuevaSalida.cant_lances = dto.cant_lances || 0;
    nuevaSalida.cant_cajones = dto.cant_cajones || 0;

    console.log('dto: ', dto);
    console.log('nuevaSalidas', nuevaSalida);

    // return nuevaSalida;
    // Guarda la entidad en la base de datos
    try {
      const res = await this.repo.save(nuevaSalida);
      return res;
    } catch (error) {
      console.error(error);
    }
  }
}
