import { Module } from '@nestjs/common';
import { SalidaPescaService } from './salida_pesca.service';
import { SalidaPescaController } from './salida_pesca.controller';
import { TypeOrmModule } from "@nestjs/typeorm";
import { Embarcacion } from "../entities/embarcacion.entity";
import { SalidaPesca } from "../entities/salida.pesca.entity";
import { Captura } from "../entities/captura.entity";
import { ArtePesca } from "../entities/arte.pesca.entity";
import { ZonaPesca } from "../entities/zona.pesca.entity";
import { Especie } from "../entities/especie.entity";
import { Puerto } from "../entities/puerto.entity";
import { UsersModule } from "../users/users.module";

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Embarcacion,
      SalidaPesca,
      Captura,
      ArtePesca,
      ZonaPesca,
      Especie,
      Puerto,
    ]),
    UsersModule,
  ],
  controllers: [SalidaPescaController],
  providers: [SalidaPescaService],
})
export class SalidaPescaModule {}
