import { IsDate, IsEnum, 
    IsNotEmpty, 
    IsNumber, 
    IsOptional, 
    isString, 
    IsString } from "class-validator";
import { ApiProperty } from "@nestjs/swagger";


export class SalidaPescaDTO {
    @ApiProperty()
    @IsNotEmpty()
    @IsDate()
    fecha_partida: Date;
    
    @ApiProperty()
    @IsNotEmpty()
    @IsDate()
    fecha_arribo: Date;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    tipo_flota: string;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    tripulantes: number;
    
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    profundidad_min: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    profundidad_max: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    horas_buceo: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    horas_pesca: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    cant_buzos: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    cant_anzuelos: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    cant_lances: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    cant_cajones: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    cant_bolsas: number;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    zonas_literal: string;
    
    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    puerto_partida: String;
    
    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    puerto_arribo: string;
    
    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    embarcacion: string;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    zonas: string;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    arte: string;
    
    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    capturas: string;

}


export class SalidaPescaUpdateDTO {
    @ApiProperty()
    @IsOptional()
    @IsDate()
    fecha_partida: Date;
    
    @ApiProperty()
    @IsOptional()
    @IsDate()
    fecha_arribo: Date;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    tipo_flota: string;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    tripulantes: number;
    
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    profundidad_min: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    profundidad_max: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    horas_buceo: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    horas_pesca: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    cant_buzos: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    cant_anzuelos: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    cant_lances: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    cant_cajones: number;
    
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    cant_bolsas: number;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    zonas_literal: string;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    puerto_partida: String;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    puerto_arribo: string;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    embarcacion: string;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    zonas: string;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    arte: string;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    capturas: string;

}