import { Body, Controller, Post, Req, UseGuards } from "@nestjs/common";
import { Crud, CrudController } from '@dataui/crud';
import { Especie } from "../entities/especie.entity";
import { SalidaPesca } from "../entities/salida.pesca.entity";
import { SalidaPescaService } from "./salida_pesca.service";
import { Request } from 'express';
import { ApiTags } from '@nestjs/swagger';
import { AuthGuard } from "../auth/auth.guard";
import { RolesGuard } from "../auth/roles.guard";

@ApiTags('Salida_Pesca')
@Crud({
  model: {
    type: SalidaPesca,
  },
  query: {
    join: {
      capturas: { eager: true }, // Incluye las capturas asociadas
      'capturas.especie': { eager: true }, // Incluye la relación con especie, si es necesario
    },
  },
})

@UseGuards(AuthGuard, RolesGuard)
@Controller('salida-pesca')
export class SalidaPescaController implements CrudController<SalidaPesca> {
  constructor(public service: SalidaPescaService) {}


  @Post()
  async createCustom(
      @Req() req: Request,
      @Body() dto: any): Promise<SalidaPesca> {
    // Lógica personalizada antes de guardar
    console.log('Custom Create DTO:', dto);



    // Guardar la entidad utilizando el servicio
    const createdSalida = await this.service.createOne(req, dto);

    // Lógica adicional después de guardar
    console.log('Entidad creada:', createdSalida);

    return createdSalida;
  }






}
