import { Module } from '@nestjs/common';
import { PuertoService } from './puerto.service';
import { PuertoController } from './puerto.controller';
import { TypeOrmModule } from "@nestjs/typeorm";
import { Embarcacion } from "../entities/embarcacion.entity";
import { SalidaPesca } from "../entities/salida.pesca.entity";
import { Captura } from "../entities/captura.entity";
import { ArtePesca } from "../entities/arte.pesca.entity";
import { ZonaPesca } from "../entities/zona.pesca.entity";
import { Especie } from "../entities/especie.entity";
import { Puerto } from "../entities/puerto.entity";
import { UsersModule } from "../users/users.module";

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Embarcacion,
      SalidaPesca,
      Captura,
      ArtePesca,
      ZonaPesca,
      Especie,
      Puerto,
    ]),
    UsersModule,
  ],
  controllers: [PuertoController],
  providers: [PuertoService],
})
export class PuertoModule {}
