// import { ApiProperty } from "@nestjs/swagger";
import { ApiProperty } from "@dataui/crud/lib/crud/swagger.helper";
import { IsNotEmpty, IsNumber, IsOptional, IsString } from "class-validator";


export class PuertoUpdateDTO {
    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    nombre: string;

    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    descripcion: string;

    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    localidad: string;


}

export class PuertoDTO {
    @ApiProperty()
    @IsOptional()
    @IsString()
    nombre: string;

    @ApiProperty()
    @IsOptional()
    @IsString()
    descripcion: string;

    @ApiProperty()
    @IsOptional()
    @IsString()
    localidad: string;


}