// import { ApiProperty } from "@nestjs/swagger";
import { ApiProperty } from "@dataui/crud/lib/crud";
import { IsNotEmpty, IsNumber, IsOptional, IsString } from "class-validator";


export class EspecieDTO {
    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    nombre_vulgar: string;

    @ApiProperty()
    @IsOptional()
    @IsString()
    nombre_cientifico: string;


}


export class EspecieUpdateDTO {
    @ApiProperty()
    @IsOptional()
    @IsString()
    nombre_vulgar: string;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    nombre_cientifico: string;

}
