import { Controller, UseGuards } from "@nestjs/common";
import { Crud, CrudController } from '@dataui/crud';
import { Especie } from "../entities/especie.entity";
import { EspecieService } from "./especie.service";
import { ApiBody, ApiExtraModels, ApiOperation, ApiParam, ApiResponse, ApiTags, getSchemaPath } from '@nestjs/swagger';
import { EspecieDTO, EspecieUpdateDTO } from './especie.dto';
import { AdminAccess } from "../auth/decorators/admin.detorator";
import { AuthGuard } from "../auth/auth.guard";
import { RolesGuard } from "../auth/roles.guard";


@ApiExtraModels(EspecieDTO, EspecieUpdateDTO)
@ApiTags('Especie')
@Crud({
  model: {
    type: Especie,
  },

  routes: {
    only: [
      'createOneBase',
      'getManyBase',
      'getOneBase',
      'updateOneBase',
      'deleteOneBase',
    ],
    deleteOneBase: {
      decorators: [
        AdminAccess(),
        ApiOperation({
          summary: 'Borra la especie seleccionada',
          description: 'Elimina una especies.',
        }),
        ApiBody({
          description: 'Datos necesarios para borrar una especie',
          schema: { $ref: getSchemaPath(EspecieDTO) },
        }),
        ApiResponse({
          status: 200,
          description: 'Entidad eliminada correctamente',
          schema: { $ref: getSchemaPath(EspecieDTO) },
        }),
      ],
    },
    updateOneBase: {
      decorators: [
        AdminAccess(),
        ApiOperation({
          summary: 'Modifica la especie seleccionada',
          description: 'Modifica una especies.',
        }),
        ApiBody({
          description: 'Datos necesarios para modificar una especie',
          schema: { $ref: getSchemaPath(EspecieUpdateDTO) },
        }),
        ApiResponse({
          status: 200,
          description: 'Entidad modificada correctamente',
          schema: { $ref: getSchemaPath(EspecieUpdateDTO) },
        }),
      ],
    },
    createOneBase: {
      decorators: [
        AdminAccess(),
        ApiOperation({
          summary: 'Crea una nueva especie',
          description: 'Crea una especie.',
        }),
        ApiBody({
          description: 'Datos necesarios para crear una nueva especie',
          schema: { $ref: getSchemaPath(EspecieDTO) },
        }),
        ApiResponse({
          status: 201,
          description: 'Entidad creada correctamente',
          schema: { $ref: getSchemaPath(EspecieDTO) },
        }),
      ],
    },
    getOneBase: {
      decorators: [
        ApiOperation({
          summary: 'Busca la especie seleccionada',
          description: 'Buscar una especies.',
        }),
        ApiBody({
          description: 'Datos necesarios para buscar una especie',
          schema: { $ref: getSchemaPath(EspecieDTO) },
        }),
        ApiResponse({
          status: 200,
          description: 'Entidad encontrada correctamente',
          schema: { $ref: getSchemaPath(EspecieDTO) },
        }),
      ],
    },
    getManyBase: {
      decorators: [
        ApiOperation({
          summary: 'Obtener una lista de especies',
          description: 'Retorna una lista de especies.',
        }),
        ApiOperation({
          summary: 'Listar todas las especies',
          description: 'Retorna una lista de especies.',
        }),
        ApiResponse({
          status: 200,
          description: 'Lista de especies encontrada correctamente.',
          schema: {
            type: 'array',
            items: { $ref: getSchemaPath(EspecieDTO) },
          },
        }),
      ],
    },
  },
})

@UseGuards(AuthGuard, RolesGuard)
@Controller('especie')
export class EspecieController implements CrudController<Especie> {
  constructor(public service: EspecieService) {}
}

