// Entidad Zona de Pesca
import { Column, Entity, OneToMany, PrimaryGeneratedColumn } from 'typeorm';
import { SalidaPesca } from './salida.pesca.entity';

@Entity()
export class ZonaPesca {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  descripcion: string;

  @Column()
  coordenadas: string;

  @OneToMany(() => SalidaPesca, (salida) => salida.zonas)
  salidas: SalidaPesca[];
}
