// Entidad Captura
import {
  Column,
  Entity,
  PrimaryGeneratedColumn } from "typeorm";
import { ROLES } from "../constants/roles";
import { Exclude } from "class-transformer";
import { BaseEntity } from "../config/base.entity";

@Entity({ name: 'users' })
export class UsersEntity extends BaseEntity{
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  firstName: string;

  @Column()
  lastName: string;

  @Column({unique: true})
  email: string;

  @Column({unique: true})
  username: string;

  @Exclude()
  @Column()
  password: string;

  @Column({ type: 'enum', enum: ROLES})
  role: ROLES;

  fullName: string;

}
