// Entidad Salida de Pesca
import {Column, Entity, ManyToMany, ManyToOne, OneToMany, PrimaryGeneratedColumn} from "typeorm";
import { Embarcacion } from "./embarcacion.entity";
import { ZonaPesca } from "./zona.pesca.entity";
import { ArtePesca } from "./arte.pesca.entity";
import { Captura     } from "./captura.entity";
import {Puerto} from "./puerto.entity";

@Entity()
export class SalidaPesca {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  fecha_partida: Date;

  @Column()
  fecha_arribo: Date;

  @Column({nullable:true})
  tipo_flota: string;

  @Column({nullable: true})
  tripulantes: number;


  @Column({nullable: true})
  profundidad_min: number;

  @Column({nullable: true})
  profundidad_max: number;

  @Column({nullable: true})
  horas_buceo: number;

  @Column({nullable: true})
  horas_pesca: number;

  @Column({nullable: true})
  cant_buzos: number;

  @Column({nullable: true})
  cant_anzuelos: number;

  @Column({nullable: true})
  cant_lances: number;

  @Column({nullable: true})
  cant_cajones: number;

  @Column({nullable: true})
  cant_bolsas: number;

  @Column({nullable: true})
  zonas_literal: string;

  @ManyToOne(()=> Puerto, puerto => puerto.salidas)
  puerto_partida: Puerto;

  @ManyToOne(()=> Puerto, puerto => puerto.salidas)
  puerto_arribo: Puerto;

  @ManyToOne(() => Embarcacion, embarcacion => embarcacion.salidas)
  embarcacion: Embarcacion;

  @ManyToMany(() => ZonaPesca, zona => zona.salidas)
  zonas: ZonaPesca[];

  @ManyToOne(() => ArtePesca, arte => arte.salidas)
  arte: ArtePesca;

  @OneToMany(() => Captura, (captura) => captura.salida, { cascade: true })
  capturas: Captura[];
}
