import {Column, Entity, OneToMany, PrimaryGeneratedColumn} from 'typeorm';
import {SalidaPesca} from "./salida.pesca.entity";

@Entity()
export class Puerto {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  nombre: string;

  @Column({nullable: true})
  descripcion: string;

  @Column({nullable: true})
  localidad: string;

  @OneToMany(() => SalidaPesca, salida => salida.embarcacion)
  salidas: SalidaPesca[];

}
