import { Column, Entity, OneToMany, PrimaryGeneratedColumn } from "typeorm";
import { Captura } from "./captura.entity";

@Entity()
export class Especie {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  codigo_especie: string;

  @Column()
  nombre_vulgar: string;

  @Column({nullable: true})
  nombre_cientifico: string;


  @OneToMany(() => Captura, captura => captura.especie)
  capturas: Captura[];
}
