// Entidad Embarcación
import { Column, Entity, OneToMany, PrimaryGeneratedColumn } from "typeorm";
import { SalidaPesca } from "./salida.pesca.entity";
import { BaseEntity } from "../config/base.entity";

@Entity()
export class Embarcacion extends BaseEntity {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  nombre: string;

  @Column()
  matricula: string;

  @Column({nullable: true})
  eslora: string;

  @Column({nullable: true})
  potencia: string;

  @Column({nullable: true})
  manga: string;

  @Column({nullable: true})
  puntal: string;

  @OneToMany(() => SalidaPesca, (salida) => salida.embarcacion)
  salidas: SalidaPesca[];
}
