// Entidad Captura
import { Column, Entity, ManyToOne, PrimaryGeneratedColumn } from "typeorm";
import { BaseEntity } from "../config/base.entity";
import { SalidaPesca } from "./salida.pesca.entity";
import { Especie} from "./especie.entity";

@Entity()
export class Captura extends BaseEntity {
  @PrimaryGeneratedColumn()
  id: number;

  @Column()
  cantidad: number;

  @Column({nullable: true})
  unidad: string; // Cajones, bolsas, lastre

  @Column({nullable: true})
  profundidad: number;

  @ManyToOne(() => SalidaPesca, salida => salida.capturas)
  salida: SalidaPesca;

  @ManyToOne(()=> Especie, especie => especie.capturas)
  especie: Especie;

}
