import { Module } from '@nestjs/common';
import { EmbarcacionService } from './embarcacion.service';
import { EmbarcacionController } from './embarcacion.controller';
import { TypeOrmModule } from '@nestjs/typeorm';
import { Embarcacion } from '../entities/embarcacion.entity';
import { SalidaPesca } from '../entities/salida.pesca.entity';
import { Captura } from '../entities/captura.entity';
import { ArtePesca } from '../entities/arte.pesca.entity';
import { ZonaPesca } from '../entities/zona.pesca.entity';
import { AuthModule } from "../auth/auth.module";
import { UsersEntity } from "../entities/users.entity";
import { UsersModule } from "../users/users.module";

@Module({
  imports: [
    UsersModule,
    TypeOrmModule.forFeature([
      Embarcacion,
      SalidaPesca,
      Captura,
      ArtePesca,
      ZonaPesca,
    ]),
  ],
  controllers: [EmbarcacionController],
  providers: [EmbarcacionService],
})
export class EmbarcacionModule {}
