import { ApiProperty } from "@nestjs/swagger";
// import { ApiProperty } from "@dataui/crud/lib/crud";
import { IsNotEmpty, IsNumber, IsOptional, IsString } from "class-validator";


export class EmbarcacionDTO {
    @ApiProperty({
        description: 'Nombre de la embarcación',
        example: 'Lancha Pesquera 01',
      })
    @IsNotEmpty()
    @IsString()
    nombre: string;

    @ApiProperty({
      description: 'Matrícula única de la embarcación',
      example: 'AB-12345',
    })
    @IsNumber()
    @IsOptional()
    matricula: number;

    @ApiProperty({
        description: 'Largo de la embarcación',
        example: '12 M',
      })
    // @IsNotEmpty()
    @IsNumber()
    @IsOptional()
    eslora: number;

    @ApiProperty()
    // @IsNotEmpty()
    @IsNumber()
    @IsOptional()
    potenciaMaquina: number;

    @ApiProperty()
    // @IsNotEmpty()
    @IsNumber()
    @IsOptional()
    trb: number;

    @ApiProperty()
    // @IsNotEmpty()
    @IsNumber()
    @IsOptional()
    manga: number;

    @ApiProperty()
    @IsOptional()
    // @IsNotEmpty()
    @IsNumber()
    puntal: number;

}


export class EmbarcacionUpdateDTO {
    @ApiProperty()
    @IsOptional()
    @IsString()
    nombre: string;

    @ApiProperty()
    @IsOptional()
    @IsNumber()
    matricula: number;

    @ApiProperty()
    @IsOptional()
    @IsNumber()
    eslora: number;

    @ApiProperty()
    @IsOptional()
    @IsNumber()
    potenciaMaquina: number;

    @ApiProperty()
    @IsOptional()
    @IsNumber()
    trb: number;

    @ApiProperty()
    @IsOptional()
    @IsNumber()
    manga: number;

    @ApiProperty()
    @IsOptional()
    @IsNumber()
    puntal: number;

}
