import { Controller, Get, UseGuards } from '@nestjs/common';
import { EmbarcacionService } from './embarcacion.service';
import { Embarcacion } from '../entities/embarcacion.entity';
import {
  Crud,
  CrudController,
  CrudRequest,
  GetManyDefaultResponse,
} from '@dataui/crud';
import { AuthGuard } from '../auth/auth.guard';
import { RolesGuard } from '../auth/roles.guard';
import {
  ApiBody,
  ApiExtraModels,
  ApiOperation,
  ApiResponse,
  ApiTags,
  getSchemaPath
} from "@nestjs/swagger";
import { EmbarcacionDTO, EmbarcacionUpdateDTO } from './embarcacion.dto';
import { AdminAccess } from "../auth/decorators/admin.detorator";

@ApiExtraModels(EmbarcacionDTO, EmbarcacionUpdateDTO)
@ApiTags('Embarcación')
@Crud({
  model: {
    type: Embarcacion,
  },

  routes: {
    only: [
      'createOneBase',
      // 'createManyBase',
      'getManyBase',
      'getOneBase',
      'updateOneBase',
      'deleteOneBase',
    ],
    deleteOneBase: {
      decorators: [
        AdminAccess(),
        ApiOperation({
          summary: 'Borra el registro de la embarcación seleccionado',
          description: 'Elimina el registro embarcación seleccionado.',
        }),
        ApiBody({
          description: 'Datos necesarios para borrar una embarcación',
          schema: { $ref: getSchemaPath(EmbarcacionDTO) },
        }),
        ApiResponse({
          status: 200,
          description: 'Entidad eliminada correctamente',
          schema: { $ref: getSchemaPath(EmbarcacionDTO) },
        }),
      ],
    },
    updateOneBase: {
      decorators: [
        AdminAccess(),
        ApiOperation({
          summary: 'Modifica el registro de la embarcación seleccionado',
          description: 'Modifica un registro de embarcación.',
        }),
        ApiBody({
          description: 'Datos necesarios para modificar una embarcación',
          schema: { $ref: getSchemaPath(EmbarcacionUpdateDTO) },
        }),
        ApiResponse({
          status: 200,
          description: 'Entidad modificada correctamente',
          schema: { $ref: getSchemaPath(EmbarcacionUpdateDTO) },
        }),
      ],
    },
    createOneBase: {
      decorators: [
        AdminAccess(),
        ApiOperation({
          summary: 'Crea una nueva embarcación',
          description: 'Crea una embarcación.',
        }),
        ApiBody({
          description: 'Datos necesarios para crear una nueva embarcación',
          schema: { $ref: getSchemaPath(EmbarcacionDTO) },
        }),
        ApiResponse({
          status: 201,
          description: 'Entidad creada correctamente',
          schema: { $ref: getSchemaPath(EmbarcacionDTO) },
        }),
      ],
    },
    // createManyBase: {
    //   decorators: [
    //     ApiBody({
    //       description: 'Datos necesarios para crear una nueva embarcación',
    //       schema: { $ref: getSchemaPath(EmbarcacionDTO) },
    //     }),
    //     ApiResponse({
    //       status: 201,
    //       description: 'Entidad encontrada correctamente',
    //       schema: { $ref: getSchemaPath(EmbarcacionDTO) },
    //     }),
    //   ],
    // },
    getOneBase: {
      decorators: [
        ApiOperation({
          summary: 'Busca la embarcación seleccionada',
          description: 'Buscar una embarcación.',
        }),
        ApiBody({
          description: 'Datos necesarios para buscar una embarcación',
          schema: { $ref: getSchemaPath(EmbarcacionDTO) },
        }),
        ApiResponse({
          status: 200,
          description: 'Entidad encontrada correctamente',
          schema: { $ref: getSchemaPath(EmbarcacionDTO) },
        }),
      ],
    },
    getManyBase: {
      decorators: [
        ApiOperation({
          summary: 'Obtener una lista de embarcaciones',
          description: 'Retorna una lista de embarcaciones.',
        }),
        ApiBody({
          description: 'Obtener una lista de embarcaciones',
          schema: { $ref: getSchemaPath(EmbarcacionDTO) },
        }),
        ApiResponse({
          status: 200,
          description: 'Entidad encontrada correctamente',
          schema: { $ref: getSchemaPath(EmbarcacionDTO) },
        }),

      ],
    },
  },
})


@Controller('embarcacion')
@UseGuards(AuthGuard, RolesGuard)
export class EmbarcacionController implements CrudController<Embarcacion> {
  constructor(public service: EmbarcacionService) {}
}
