import { Module } from '@nestjs/common';
import { CapturaService } from './captura.service';
import { CapturaController } from './captura.controller';
import { TypeOrmModule } from "@nestjs/typeorm";
import { Embarcacion } from "../entities/embarcacion.entity";
import { SalidaPesca } from "../entities/salida.pesca.entity";
import { Captura } from "../entities/captura.entity";
import { ArtePesca } from "../entities/arte.pesca.entity";
import { ZonaPesca } from "../entities/zona.pesca.entity";
import { Especie } from "../entities/especie.entity";
import { UsersModule } from "../users/users.module";

@Module({
  imports: [
    TypeOrmModule.forFeature([
      Embarcacion,
      SalidaPesca,
      Captura,
      ArtePesca,
      ZonaPesca,
      Especie,
    ]),
    UsersModule,
  ],
  controllers: [CapturaController],
  providers: [CapturaService],
})
export class CapturaModule {}
