import { IsEnum, 
    IsNotEmpty, 
    IsNumber, 
    IsOptional, 
    IsString } from "class-validator";
import { ApiProperty } from "@nestjs/swagger";


export class CapturaDTO {
    @ApiProperty()
    @IsNotEmpty()
    @IsNumber()
    cantidad: number;

    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    unidad: string;

    @ApiProperty()
    @IsNotEmpty()
    @IsNumber()
    profundidad: number;

    @ApiProperty()
    @IsNotEmpty()
    @IsNumber()
    salida: number;

    @ApiProperty()
    @IsNotEmpty()
    @IsNumber()
    especie: number;

}


export class CapturaUpdateDTO {
    @ApiProperty()
    @IsOptional()
    @IsNumber()
    cantidad: number;

    @ApiProperty()
    @IsOptional()
    @IsString()
    unidad: string;

    @ApiProperty()
    @IsOptional()
    @IsNumber()
    profundidad: number;

    @ApiProperty()
    @IsOptional()
    @IsNumber()
    salida: number;

    @ApiProperty()
    @IsOptional()
    @IsNumber()
    especie: number;
}