import { Body, Controller, Post, Req, UnauthorizedException } from "@nestjs/common";
import { AuthService } from './auth.service';
import { AuthDTO } from './auth.dto';
import { ApiTags } from "@nestjs/swagger";

@ApiTags('Auth')
@Controller('auth')
export class AuthController {
    constructor(private readonly authService: AuthService){}
    @Post('login')
    async login(
      @Body() {username,password}: AuthDTO
    ){
        const userValidate = await this.authService.validateUser(username,password)
        if(!userValidate){
            throw new UnauthorizedException('Data not valid');
        }
        const jwt = await this.authService.generateJWT(userValidate);

        userValidate.fullName =userValidate.firstName + ' ' + userValidate.lastName;

        const res = {
            ...jwt,
            user : userValidate,
        }

        return res;

        // return jwt;

    }
}
