import { ApiProperty } from "@nestjs/swagger";
import { IsNotEmpty, IsNumber, IsOptional, IsString } from "class-validator";


export class ArtePescaDTO {
    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    tipo: string;

    @ApiProperty()
    @IsNotEmpty()
    @IsString()
    descripcion: string;

}


export class ArtePescaUpdateDTO {
    @ApiProperty()
    @IsOptional()
    @IsString()
    tipo: string;
    
    @ApiProperty()
    @IsOptional()
    @IsString()
    descripcion: string;

}
