import { Controller, UseGuards } from "@nestjs/common";
import { Crud, CrudController } from '@dataui/crud';
import { ArtePesca } from "../entities/arte.pesca.entity";
import { ArtePescaService } from "./arte_pesca.service";
import { ApiBody, ApiExtraModels, ApiOperation, ApiResponse, ApiTags, getSchemaPath } from '@nestjs/swagger';
import { ArtePescaDTO, ArtePescaUpdateDTO } from './arte_pesca.dto';
import { AuthGuard } from "../auth/auth.guard";
import { RolesGuard } from "../auth/roles.guard";
import { AdminAccess } from "../auth/decorators/admin.detorator";

@ApiExtraModels(ArtePescaDTO, ArtePescaUpdateDTO)
@ApiTags('Arte de Pesca')
@Crud({
  model: {
    type: ArtePesca,
  },

  routes: {
    only: [
      'createOneBase',
      'getManyBase',
      'getOneBase',
      'updateOneBase',
      'deleteOneBase',
    ],
    deleteOneBase: {
      decorators: [
        AdminAccess(),
        ApiOperation({
          summary: 'Borra el arte de pesca seleccionado',
          description: 'Elimina un registro de arte de pesca.',
        }),
        ApiBody({
          description: 'Datos necesarios para borrar un arte de pesca',
          schema: { $ref: getSchemaPath(ArtePescaDTO) },
        }),
        ApiResponse({
          status: 200,
          description: 'Entidad eliminada correctamente',
          schema: { $ref: getSchemaPath(ArtePescaDTO) },
        }),
      ],
    },
    updateOneBase: {
      decorators: [
        AdminAccess(),
        ApiOperation({
          summary: 'Modifica el registro de arte de pesca seleccionado',
          description: 'Modifica el registro de arte de pesca.',
        }),
        ApiBody({
          description: 'Datos necesarios para modificar un arte de pesca',
          schema: { $ref: getSchemaPath(ArtePescaUpdateDTO) },
        }),
        ApiResponse({
          status: 200,
          description: 'Entidad modificada correctamente',
          schema: { $ref: getSchemaPath(ArtePescaUpdateDTO) },
        }),
      ],
    },
    createOneBase: {
      decorators: [
        AdminAccess(),
        ApiOperation({
          summary: 'Crea un nuevo arte de pesca',
          description: 'Crea un arte de pesca.',
        }),
        ApiBody({
          description: 'Datos necesarios para crear un nuevo arte de pesca',
          schema: { $ref: getSchemaPath(ArtePescaDTO) },
        }),
        ApiResponse({
          status: 201,
          description: 'Entidad creada correctamente',
          schema: { $ref: getSchemaPath(ArtePescaDTO) },
        }),
      ],
    },
    getOneBase: {
      decorators: [
        ApiOperation({
          summary: 'Busca el arte de pesca seleccionado',
          description: 'Buscar un arte de pesca.',
        }),
        ApiBody({
          description: 'Datos necesarios para buscar un arte de pesca',
          schema: { $ref: getSchemaPath(ArtePescaDTO) },
        }),
        ApiResponse({
          status: 200,
          description: 'Entidad encontrada correctamente',
          schema: { $ref: getSchemaPath(ArtePescaDTO) },
        }),
      ],
    },
    getManyBase: {
      decorators: [
        ApiOperation({
          summary: 'Obtener una lista de artes de pesca',
          description: 'Retorna una lista de artes de pesca.',
        }),
        ApiOperation({
          summary: 'Listar todas las artes de pesca',
          description: 'Retorna una lista de artes de pesca.',
        }),
        ApiResponse({
          status: 200,
          description: 'Lista de artes de pesca encontrada correctamente.',
          schema: {
            type: 'array',
            items: { $ref: getSchemaPath(ArtePescaDTO) },
          },
        }),
      ],
    },
  },
})

@UseGuards(AuthGuard, RolesGuard)
@Controller('arte-pesca')
export class ArtePescaController implements CrudController<ArtePesca> {
  constructor(public service: ArtePescaService) {}
}
