import { Module } from '@nestjs/common';
import { AppController } from './app.controller';
import { AppService } from './app.service';
import { TypeOrmModule } from '@nestjs/typeorm';
import { ConfigModule } from '@nestjs/config';
import { DatabaseConfig } from './config/db.config';
import { EmbarcacionModule } from './embarcacion/embarcacion.module';
import config from './config/config';
import { ArtePescaModule } from './arte_pesca/arte_pesca.module';
import { ZonaPescaModule } from './zona_pesca/zona_pesca.module';
import { EspecieModule } from './especie/especie.module';
import { CapturaModule } from './captura/captura.module';
import { SalidaPescaModule } from './salida_pesca/salida_pesca.module';
import { PuertoModule } from './puerto/puerto.module';
import { UsersModule } from './users/users.module';
import { AuthModule } from './auth/auth.module';

@Module({
  imports: [
    ConfigModule.forRoot({
      isGlobal: true,
      load: [config],
      envFilePath: ['.env'],
    }),
    TypeOrmModule.forRootAsync({
      imports: [ConfigModule],
      useClass: DatabaseConfig,
    }),
    UsersModule,
    EmbarcacionModule,
    ArtePescaModule,
    ZonaPescaModule,
    EspecieModule,
    CapturaModule,
    SalidaPescaModule,
    PuertoModule,
    AuthModule,
    
  ],
  controllers: [AppController],
  providers: [AppService],
})
export class AppModule {}
