# Sistema de Gestión de Pesca

Sistema compuesto por una API REST desarrollada en NestJS y una interfaz administrativa web construida con React-Admin.

## Estructura del Proyecto

```
.
├── nestjs/         # Backend API REST (NestJS)
└── pesca-admin/    # Frontend Admin (React-Admin)
```

## Requisitos Previos

- Node.js (v20 o superior)
- npm (incluido con Node.js)
- MySQL (v8.0 o superior)

## Configuración de la Base de Datos

1. Crear una base de datos MySQL:
```sql
CREATE DATABASE pesca_db;
```

2. Crear un usuario y asignar permisos:
```sql
CREATE USER 'pesca_user'@'localhost' IDENTIFIED BY 'tu_contraseña';
GRANT ALL PRIVILEGES ON pesca_db.* TO 'pesca_user'@'localhost';
FLUSH PRIVILEGES;
```

## Instalación y Despliegue de la API (NestJS)

1. Navegar al directorio del backend:
```bash
cd nestjs
```

2. Instalar dependencias:
```bash
npm install
```

3. Configurar variables de entorno:
   - Crear archivo `.env` en el directorio `nestjs/`:
```env
# Database
DB_TYPE=mysql
DB_HOST=localhost
DB_PORT=3606
DB_USERNAME=pesca_user
DB_PASSWORD=tu_contraseña
DB_NAME=pesca_db

# Server
NEST_PORT=3355

# Authentication
JWT_SECRET=tu_clave_secreta_jwt
HASH_SALT=10
```

4. Ejecutar migraciones:
```bash
npm run migration:run
```

5. Iniciar el servidor:

Para desarrollo:
```bash
npm run start:dev
```

Para producción:
```bash
npm run build
npm run start:prod
```

La API estará disponible en `http://localhost:3355`

## Instalación y Despliegue del Frontend (React-Admin)

1. Navegar al directorio del frontend:
```bash
cd pesca-admin
```

2. Instalar dependencias:
```bash
npm install
```

3. Configurar variables de entorno:
   - Crear archivo `.env` en el directorio `pesca-admin/`:
```env
VITE_API_URL=http://localhost:3355
```

4. Iniciar la aplicación:

Para desarrollo:
```bash
npm run dev
```

Para producción:
```bash
npm run build
npm run serve
```

La interfaz web estará disponible en:
- Desarrollo: `http://localhost:5173`
- Producción: El puerto que asigne el servidor de producción

## Características

### API REST (NestJS)
- Autenticación JWT
- CRUD completo para gestión de recursos pesqueros
- Validación de datos
- Documentación Swagger
- Roles y permisos

### Interfaz Administrativa (React-Admin)
- Autenticación de usuarios
- Gestión de salidas de pesca
- Gestión de embarcaciones
- Gestión de puertos
- Gestión de especies
- Panel de administración de usuarios

## Documentación API

La documentación Swagger está disponible en:
```
http://localhost:3000/api
```

## Solución de Problemas Comunes

### Error de conexión a la base de datos
Verificar:
- Servicio MySQL activo
- Credenciales correctas en `.env`
- Puerto 3306 disponible

### Error en las migraciones
```bash
# Revertir última migración
npm run migration:revert

# Regenerar migraciones
npm run migration:generate

# Ejecutar migraciones
npm run migration:run
```

## Licencia

[MIT](LICENSE)
